# -*- coding: utf-8 -*-
import json
import os


from pathlib import Path
from tencentcloud.common.common_client import CommonClient
from tencentcloud.common import credential
from tencentcloud.common.exception.tencent_cloud_sdk_exception import TencentCloudSDKException
from tencentcloud.common.profile.client_profile import ClientProfile
from tencentcloud.common.profile.http_profile import HttpProfile
from qcloud_cos import CosConfig
from qcloud_cos import CosS3Client

EndPoint        = "lke.tencentcloudapi.com"
SecretID        = "xxxxxxxxxxxxxxxxxxx"
SecretKey       = "xxxxxxxxxxxxxxxxxxx"
BotBizID        = "xxxxxxxxxxxxxxxxxxx"
TypeKeyRealtime = "realtime" # 实时文件上传类型
TypeKeyOffline  = "offline"  # 离线文档上传类型
Region          = "ap-jakarta"


filePath = "./test2.txt"
fileName = Path(filePath).name
fileExt = Path(filePath).suffix[1:]
print("filePath: ",filePath)
print("fileName: ",fileName)
print("fileExt: ",fileExt)



######## step 1 获取临时密钥 ###########
try:
    cred = credential.Credential(SecretID, SecretKey)
    httpProfile = HttpProfile()
    httpProfile.endpoint = EndPoint
    clientProfile = ClientProfile()
    clientProfile.httpProfile = httpProfile

    # 请注意，此处为离线文档上传，TypeKey取值为offline;
    # 如果需要复用此处代码上传实时文档，需要修改TypeKey取值为 realtime
    params = {
        "BotBizId": BotBizID,
        "FileType": fileExt,
        "IsPublic": False,
        "TypeKey": TypeKeyOffline

    }
    common_client = CommonClient("lke", "2023-11-30", cred, Region, profile=clientProfile)
    resp = common_client.call_json("DescribeStorageCredential", params)
    tmpSecretId = resp['Response']['Credentials']['TmpSecretId']
    tmpSecretKey = resp['Response']['Credentials']['TmpSecretKey']
    tmpToken = resp['Response']['Credentials']['Token']
    uploadPath = resp['Response']['UploadPath']
    bucket = resp['Response']['Bucket']
    region = resp['Response']['Region']

    print("======== DescribeStorageCredential Success =======")
    print("tmpSecretId: ", tmpSecretId)
    print("tmpSecretKey: ", tmpSecretKey)
    print("tmpToken: ", tmpToken)
    print("uploadPath: ", uploadPath)
    print("bucket: ", bucket)
    print("region: ", region)
except TencentCloudSDKException as err:
    print(err)



print("======= 获取临时密钥成功 =============\n\n")


######## step 2 上传文档到知识引擎的cos ###########
# 参考：https://www.tencentcloud.com/document/product/436/14113
config = CosConfig(Region=region, SecretId=tmpSecretId, SecretKey=tmpSecretKey, Token=tmpToken, Scheme='https')
client = CosS3Client(config)
# 使用高级接口上传一次，不重试，此时没有使用断点续传的功能
response = client.upload_file(
    Bucket=bucket,
    Key=uploadPath,
    LocalFilePath=fileName,
    EnableMD5=False,
    progress_callback=None
)

print('上传后结果:' + str(response))
rsp = response
eTag = rsp.get('ETag')
cosHash = rsp.get('x-cos-hash-crc64ecma')
print('etag: ' + eTag)
print('coshash: ' + cosHash)
print(" \n\n ============== \n\n")


######### step 3 从cos转存到知识引擎 ###########
try:
    params = {
        "BotBizId": BotBizID,
        "FileName": fileName,
        "FileType": fileExt,
        "CosUrl": uploadPath,
        "ETag": eTag,
        "CosHash": cosHash,
        "Size": str(os.path.getsize(fileName)),
        "AttrRange": 1
    }

    cred = credential.Credential(SecretID, SecretKey)

    httpProfile = HttpProfile()
    httpProfile.endpoint = EndPoint
    clientProfile = ClientProfile()
    clientProfile.httpProfile = httpProfile
    common_client = CommonClient("lke", "2023-11-30", cred, Region, profile=clientProfile)
    resp = common_client.call_json("SaveDoc", params)
except TencentCloudSDKException as err:
    print(err)

